using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Generator.Message;
using inetsoftware.Pdfc.Results;
using System;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample to show the difference in number of pages between 2 PDF files.
    /// Expects 2 arguments - the paths of the PDF files
    /// </summary>
    public class NumOfDifferencePageNumber
    {
        static NumOfDifferencePageNumber()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show the difference in number of pages between 2 PDF files.
        /// </summary>
        /// /// <param name="args">Expected 2 arguments, the path of the PDF files</param>
        public static void Main(string[] args)
        {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            using (ResultModel result = new PDFComparer().Compare(args[0], args[1]))
            {
                InfoData infoData = result.GetComparisonParameters();

                int firstPageCount = infoData.FirstPageCount;
                int secondPageCount = infoData.SecondPageCount;
                System.Console.WriteLine("Page count first document: " + firstPageCount);
                System.Console.WriteLine("Page count second document = " + secondPageCount);

                int differencePageCount = firstPageCount - secondPageCount;

                System.Console.WriteLine("Page count differences:" + differencePageCount);
            }
        }
    }
}